package com.logicbig.example;

import org.junit.Test;
import org.mockito.Mockito;

public class ProcessorTest {

    @Test
    public void processTest() {
        MyService myService = Mockito.mock(MyService.class);
        String processName = "dummy-process-name";
        Mockito.when(myService.doSomething(processName))
               .thenReturn(10);
        MyProcessor myProcessor = new MyProcessor(processName, myService);
        myProcessor.process();
        Mockito.verify(myService).doSomething(Mockito.anyString());
    }
}