package com.logicbig.example;

import org.junit.jupiter.api.Test;

import java.time.Duration;
import static org.junit.jupiter.api.Assertions.*;

class TimeoutTest {

    @Test
    void testWithAssertTimeout() {
        // >> Verifying the code runs within the given time (200 milliseconds)
        assertTimeout(Duration.ofMillis(200), () -> {
            // Simulate some work
            Thread.sleep(100); // Sleep for 100ms
        });
    }

    @Test
    void testMethodReturnsObjectWithinTimeout() {
        // >> Verifying that the code executes within the given time (500 milliseconds)
        String result = assertTimeout(Duration.ofMillis(500), () -> {
            // Simulate some work that returns a value after a delay
            Thread.sleep(200); // Sleep for 200ms
            return "Hello, World!"; // Returning the result after the delay
        });

        // >> Verifying that the returned result is as expected
        assertEquals("Hello, World!", result);
    }

    @Test
    void testMethodReturnsObjectWithinTimeoutPreemptively() {
        // >> Verifying that the method completes within 500 milliseconds
        String result = assertTimeoutPreemptively(Duration.ofMillis(500), () -> {
            // Simulate some work that returns a value after a delay
            Thread.sleep(200); // Simulate a delay of 200ms
            return "Hello, World!"; // Return the result after the delay
        });

        // >> Verifying that the returned result is as expected
        assertEquals("Hello, World!", result);
    }
}