package com.logicbig.example;

import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePreDestroyCallback;

public class ResourceCleanupExtension implements TestInstancePreDestroyCallback {

    @Override
    public void preDestroyTestInstance(ExtensionContext context) {
        Object testInstance = context.getRequiredTestInstance();

        System.out.println("Cleaning up resources for: " + 
                          testInstance.getClass().getSimpleName());
        
        if (testInstance instanceof AutoCloseable closeable) {
            try {
                closeable.close();
            } catch (Exception e) {
                System.err.println("Failed to close test instance: " + e.getMessage());
            }
        }
    }
}