package com.logicbig.example;

import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import java.lang.reflect.Field;

public class ServiceInjectorExtension implements TestInstancePostProcessor {

    @Override
    public void postProcessTestInstance(Object testInstance, 
                                    ExtensionContext context) throws Exception {
        for (Field field : testInstance.getClass().getDeclaredFields()) {
            if (field.getType() == MyService.class) {
                field.setAccessible(true);
                field.set(testInstance, new MyService("Auto-Injected Config"));
            }
        }
    }
}