package com.logicbig.example;

import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

/**
 * Demonstrates the default PER_METHOD lifecycle.
 * A new instance is created for each test method.
 */
@TestInstance(TestInstance.Lifecycle.PER_METHOD)
public class TestInstancePerMethodTest {

    private int counter = 0;

    @Test
    void testMethod1() {
        counter++;
        System.out.println("TestMethod1 - Counter: " + counter);
        System.out.println("TestMethod1 - Instance: " + this);
    }

    @Test
    void testMethod2() {
        counter++;
        System.out.println("TestMethod2 - Counter: " + counter);
        System.out.println("TestMethod2 - Instance: " + this);
    }

    @Test
    void testMethod3() {
        counter++;
        System.out.println("TestMethod3 - Counter: " + counter);
        System.out.println("TestMethod3 - Instance: " + this);
    }
}