package com.logicbig.example;

import org.junit.jupiter.api.*;

/**
 * Demonstrates PER_CLASS lifecycle where a single instance
 * is shared across all test methods.
 */
@TestInstance(TestInstance.Lifecycle.PER_CLASS)
public class TestInstancePerClassTest {

    private int counter = 0;

    @BeforeAll
    void beforeAll() {
        System.out.println("BeforeAll - Instance: " + this);
        System.out.println("BeforeAll - Counter initialized to: " + counter);
    }

    @BeforeEach
    void beforeEach() {
        System.out.println("BeforeEach - Counter before test: " + counter);
    }

    @Test
    void testMethod1() {
        counter++;
        System.out.println("TestMethod1 - Counter: " + counter);
        System.out.println("TestMethod1 - Instance: " + this);
    }

    @Test
    void testMethod2() {
        counter++;
        System.out.println("TestMethod2 - Counter: " + counter);
        System.out.println("TestMethod2 - Instance: " + this);
    }

    @Test
    void testMethod3() {
        counter++;
        System.out.println("TestMethod3 - Counter: " + counter);
        System.out.println("TestMethod3 - Instance: " + this);
    }

    @AfterEach
    void afterEach() {
        System.out.println("AfterEach - Counter after test: " + counter);
    }

    @AfterAll
    void afterAll() {
        System.out.println("AfterAll - Final counter: " + counter);
        System.out.println("AfterAll - Instance: " + this);
    }
}