package com.logicbig.example;

import org.junit.platform.suite.api.SelectClasses;
import org.junit.platform.suite.api.Suite;
import org.junit.platform.suite.api.SuiteDisplayName;

/**
 * Example demonstrating @SelectClasses annotation
 * This suite explicitly selects specific test classes
 */
@Suite
@SuiteDisplayName("Critical Business Functionality Suite")
@SelectClasses({
    CriticalLoginTest.class,       // Select critical login tests
    EssentialPaymentTest.class,    // Select essential payment tests
    OrderValidationTest.class      // Select order validation tests
    // Note: ExcludedTest and AnotherExcludedTest are NOT selected
})
public class SuiteSelectClassesExample {
    // Only the three explicitly selected classes will be executed
    // This provides precise control over suite composition
}