package com.logicbig.example;

import org.junit.platform.suite.api.IncludeClassNamePatterns;
import org.junit.platform.suite.api.SelectPackages;
import org.junit.platform.suite.api.Suite;
import org.junit.platform.suite.api.SuiteDisplayName;

/**
 * Example demonstrating @IncludeClassNamePatterns annotation
 * This suite includes test classes based on name patterns
 */
@Suite
@SuiteDisplayName("Pattern-Based Class Inclusion Suite")
@SelectPackages("com.logicbig.example")  // Select all packages
@IncludeClassNamePatterns({
    ".*Test$",           // Include classes ending with "Test"
    ".*Service.*",       // Include classes containing "Service"
    "^User.*",           // Include classes starting with "User"
    ".*Integration.*"    // Include classes containing "Integration"
})
public class SuiteIncludeClassNamePatternsExample {
    // Classes matching any of the patterns will be included
    // Classes not matching any pattern will be excluded
}