package com.logicbig.example;

import org.junit.platform.suite.api.*;

/**
 * Example demonstrating combined suite filters
 * This suite uses multiple filtering strategies together
 */
@Suite
@SuiteDisplayName("Comprehensive Filtered Test Suite")
@SelectPackages("com.logicbig.example")  // Select all packages

// Package filtering
@IncludePackages({
    "com.logicbig.example"
})

// Class name pattern filtering
@IncludeClassNamePatterns(".*Test$")      // Only include classes ending with "Test"
@ExcludeClassNamePatterns(".*Legacy.*")   // Exclude classes containing "Legacy"

// Tag filtering
@IncludeTags({
    "critical",     // Include tests tagged as critical
    "user",         // Include tests tagged as user-related
    "payment"       // Include tests tagged as payment-related
})
@ExcludeTags({
    "slow",         // Exclude slow tests
    "integration"   // Exclude integration tests
})

// Engine filtering (optional - commented out as we only use JUnit Jupiter)
// @IncludeEngines("junit-jupiter")  // Only use JUnit Jupiter engine
// @ExcludeEngines("junit-vintage")  // Exclude JUnit 4 engine

public class SuiteCombiningFiltersExample {
    // This suite combines multiple filters:
    // 1. Only classes ending with "Test"
    // 2. Excluding classes with "Legacy" in name
    // 3. Including tests tagged "critical", "user", or "payment"
    // 4. Excluding tests tagged "slow" or "integration"
}