package com.logicbig.example;

import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.RepetitionInfo;

import static org.junit.jupiter.api.Assertions.fail;

public class RepeatedTestFailureThresholdTest {

    @RepeatedTest(value = 5, failureThreshold = 2)
    void repeatedTestWithFailureThreshold(RepetitionInfo repetitionInfo) {

        int current = repetitionInfo.getCurrentRepetition();
        int threshold = repetitionInfo.getFailureThreshold();

        System.out.println("repetition=" + current + ", failureThreshold=" + threshold);

        if (current == 2 || current == 4) {
            fail("intentional failure");
        }
    }
}