package com.logicbig.example;

import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

import static org.junit.jupiter.api.Assertions.assertTrue;

public class ParameterizedEnumSourceTest {

    enum Direction {NORTH, SOUTH, EAST, WEST}

    @ParameterizedTest(name = "#{index} enum value: {0}")
    @EnumSource(Direction.class)
    void allEnumConstantsShouldHaveName(Direction dir) {
        assertTrue(dir.name().length() > 0);
    }

    @ParameterizedTest(name = "#{index} included: {0}")
    @EnumSource(value = Direction.class, names = {"NORTH", "SOUTH"})
    void includeSpecificConstants(Direction dir) {
        assertTrue(dir == Direction.NORTH || dir == Direction.SOUTH);
    }

    @ParameterizedTest(name = "#{index} excluded: {0}")
    @EnumSource(value = Direction.class, names = {"EAST", "WEST"}, mode = EnumSource.Mode.EXCLUDE)
    void excludeSomeConstants(Direction dir) {
        assertTrue(dir == Direction.NORTH || dir == Direction.SOUTH);
    }
}