package com.logicbig.example;

import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvFileSource;

import static org.junit.jupiter.api.Assertions.assertEquals;

public class ParameterizedCsvFileSourceTest {

    @ParameterizedTest(name = "#{index} {0} + {1} = {2}")
    @CsvFileSource(resources = "/numbers.csv", numLinesToSkip = 1)
    void sumFromCsv(int a, int b, int expectedSum) {
        assertEquals(expectedSum, a + b);
    }
}