package com.logicbig.example;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertTrue;

class ShoppingCartBddTest {

    @Nested
    @DisplayName("Given an empty shopping cart")
    class GivenEmptyShoppingCart {
        protected ShoppingCart cart;

        @BeforeEach
        void givenEmptyCart() {
            cart = new ShoppingCart();
        }

        @Nested
        @DisplayName("When a product is added")
        class WhenProductAdded {
            protected Product product;

            @BeforeEach
            void whenProductAdded() {
                product = new Product("Laptop", 999.99);
                cart.addProduct(product);
            }

            @Test
            @DisplayName("Then cart should contain the product")
            void cartShouldContainProduct() {
                assertTrue(cart.getProducts().contains(product));
                assertEquals(1, cart.getItemCount());
            }

            @Test
            @DisplayName("Then total price should be product price")
            void totalPriceShouldBeCorrect() {
                assertEquals(999.99, cart.getTotalPrice(), 0.001);
            }
        }
    }

    @Nested
    @DisplayName("Given a shopping cart with one product")
    class GivenCartWithOneProduct {
        protected ShoppingCart cart;
        protected Product product;

        @BeforeEach
        void givenCartWithProduct() {
            cart = new ShoppingCart();
            product = new Product("Mouse", 29.99);
            cart.addProduct(product);
        }

        @Nested
        @DisplayName("When another product is added")
        class WhenAnotherProductAdded {
            protected Product secondProduct;

            @BeforeEach
            void whenAnotherProductAdded() {
                secondProduct = new Product("Keyboard", 79.99);
                cart.addProduct(secondProduct);
            }

            @Test
            @DisplayName("Then cart should have two items")
            void shouldHaveTwoItems() {
                assertEquals(2, cart.getItemCount());
            }

            @Test
            @DisplayName("Then total price should be sum of both products")
            void totalPriceShouldBeSum() {
                assertEquals(109.98, cart.getTotalPrice(), 0.001);
            }
        }

        @Nested
        @DisplayName("When the product is removed")
        class WhenProductRemoved {

            @BeforeEach
            void whenProductRemoved() {
                cart.removeProduct(product);
            }

            @Test
            @DisplayName("Then cart should be empty")
            void cartShouldBeEmpty() {
                assertTrue(cart.getProducts().isEmpty());
                assertEquals(0, cart.getItemCount());
            }

            @Test
            @DisplayName("Then total price should be zero")
            void totalPriceShouldBeZero() {
                assertEquals(0.0, cart.getTotalPrice(), 0.001);
            }
        }
    }
}