package com.logicbig.example;

import java.util.ArrayList;
import java.util.List;

public class ShoppingCart {
    private final List<Product> products = new ArrayList<>();

    public void addProduct(Product product) {
        products.add(product);
    }

    public void removeProduct(Product product) {
        products.remove(product);
    }

    public List<Product> getProducts() {
        return new ArrayList<>(products);
    }

    public int getItemCount() {
        return products.size();
    }

    public double getTotalPrice() {
        return products.stream()
                       .mapToDouble(Product::getPrice)
                       .sum();
    }
}