package com.logicbig.example;

import org.junit.jupiter.api.*;
import static org.junit.jupiter.api.Assertions.assertTrue;

public class NestedClassLifecycleAnnotationsTest {
    private static StringBuilder lifecycleLog = new StringBuilder();

    @BeforeAll
    static void beforeAllOuter() {
        lifecycleLog.append("Outer BeforeAll | ");
        System.out.println("Outer BeforeAll executed");
    }

    @AfterAll
    static void afterAllOuter() {
        lifecycleLog.append("Outer AfterAll | ");
        System.out.println("Outer AfterAll executed");
        System.out.println("Final Lifecycle Log: " + lifecycleLog.toString());
    }

    @BeforeEach
    void beforeEachOuter() {
        lifecycleLog.append("Outer BeforeEach | ");
        System.out.println("Outer BeforeEach executed");
    }

    @AfterEach
    void afterEachOuter() {
        lifecycleLog.append("Outer AfterEach | ");
        System.out.println("Outer AfterEach executed");
    }

    @Test
    void outerTestOne() {
        lifecycleLog.append("Outer Test1 | ");
        System.out.println("Outer Test1 executed");
        assertTrue(true);
    }

    @Test
    void outerTestTwo() {
        lifecycleLog.append("Outer Test2 | ");
        System.out.println("Outer Test2 executed");
        assertTrue(true);
    }

    @Nested
    class InnerClassWithoutPerClass {

        @BeforeEach
        void beforeEachInner() {
            lifecycleLog.append("Inner BeforeEach | ");
            System.out.println("Inner BeforeEach executed");
        }

        @AfterEach
        void afterEachInner() {
            lifecycleLog.append("Inner AfterEach | ");
            System.out.println("Inner AfterEach executed");
        }

        // This would cause an error before Java 16 if uncommented:
        //   @BeforeAll
        //   static void beforeAllInner() {
        //    }

        @Test
        void innerTestOne() {
            lifecycleLog.append("Inner Test1 | ");
            System.out.println("Inner Test1 executed");
            assertTrue(true);
        }

        @Test
        void innerTestTwo() {
            lifecycleLog.append("Inner Test2 | ");
            System.out.println("Inner Test2 executed");
            assertTrue(true);
        }

        @Nested
        class DeepNestedClass {
            @BeforeEach
            void beforeEachDeep() {
                lifecycleLog.append("Deep BeforeEach | ");
                System.out.println("Deep BeforeEach executed");
            }

            @AfterEach
            void afterEachDeep() {
                lifecycleLog.append("Deep AfterEach | ");
                System.out.println("Deep AfterEach executed");
            }

            @Test
            void deepTest() {
                lifecycleLog.append("Deep Test | ");
                System.out.println("Deep Test executed");
                assertTrue(true);
            }
        }
    }

    @Nested
    @TestInstance(TestInstance.Lifecycle.PER_CLASS)
    class InnerClassWithPerClass {
        private int testCounter = 0;

        @BeforeAll
        void beforeAllInner() {
            // can be non-static due to @TestInstance(PER_CLASS)
            lifecycleLog.append("PerClass Inner BeforeAll | ");
            System.out.println("PerClass Inner BeforeAll executed");
        }

        @AfterAll
        void afterAllInner() {
            lifecycleLog.append("PerClass Inner AfterAll | ");
            System.out.println("PerClass Inner AfterAll executed");
        }

        @BeforeEach
        void beforeEachInner() {
            testCounter++;
            lifecycleLog.append("PerClass Inner BeforeEach | ");
            System.out.println("PerClass Inner BeforeEach executed - Counter: " + testCounter);
        }

        @AfterEach
        void afterEachInner() {
            lifecycleLog.append("PerClass Inner AfterEach | ");
            System.out.println("PerClass Inner AfterEach executed");
        }

        @Test
        void perClassInnerTestOne() {
            lifecycleLog.append("PerClass Inner Test1 | ");
            System.out.println("PerClass Inner Test1 executed - Counter: " + testCounter);
            assertTrue(testCounter >= 1);
        }

        @Test
        void perClassInnerTestTwo() {
            lifecycleLog.append("PerClass Inner Test2 | ");
            System.out.println("PerClass Inner Test2 executed - Counter: " + testCounter);
            assertTrue(testCounter >= 2);
        }
    }
}