package com.logicbig.example;

import org.junit.jupiter.api.*;
import org.junit.jupiter.api.extension.*;

@ExtendWith(SimpleLifecycleCallbacksTest.SimpleLifecycleExtension.class)
public class SimpleLifecycleCallbacksTest {

    @BeforeAll
    static void beforeAll(){
        System.out.println("Test Class: @BeforeAll method");
    }

    @BeforeEach
    void setup() {
        System.out.println("Test Class: @BeforeEach method");
    }

    @Test
    void myTest() {
        System.out.println("Test Class: @Test method");
    }

    @AfterEach
    void tearDown() {
        System.out.println("Test Class: @AfterEach method");
    }

    @AfterAll
    static void afterAll() {
        System.out.println("Test Class: @AfterAll method");
    }

    static class SimpleLifecycleExtension implements
            BeforeAllCallback, AfterAllCallback, 
            BeforeEachCallback, AfterEachCallback, 
            BeforeTestExecutionCallback, AfterTestExecutionCallback {

        @Override
        public void beforeAll(ExtensionContext c) {
            System.out.println("Extension Class: BeforeAllCallback"); }

        @Override
        public void afterAll(ExtensionContext c) {
            System.out.println("Extension Class: AfterAllCallback"); }

        @Override
        public void beforeEach(ExtensionContext c) {
            System.out.println("Extension Class: BeforeEachCallback"); }

        @Override
        public void afterEach(ExtensionContext c) {
            System.out.println("Extension Class: AfterEachCallback"); }

        @Override
        public void beforeTestExecution(ExtensionContext c) {
            System.out.println("Extension Class: BeforeTestExecutionCallback"); }

        @Override
        public void afterTestExecution(ExtensionContext c) {
            System.out.println("Extension Class: AfterTestExecutionCallback"); }
    }
}