package com.logicbig.example;

import org.junit.jupiter.api.extension.*;

public class DatabaseExtension implements BeforeAllCallback,
        AfterAllCallback, BeforeEachCallback {

    @Override
    public void beforeAll(ExtensionContext context) {
        System.out.println("DB: Starting connection pool");
    }

    @Override
    public void beforeEach(ExtensionContext context) {
        System.out.println("DB: Clearing tables for test: " + context.getDisplayName());
    }

    @Override
    public void afterAll(ExtensionContext context) {
        System.out.println("DB: Closing connection pool");
    }
}