package com.logicbig.example;


import com.logicbig.util.TestPrinter;
import org.junit.jupiter.api.*;

class CalcTest {

    private Calc calc;
    private static TestPrinter testPrinter;

    @BeforeAll
    static void initForAll() {
        testPrinter.print("-- running @BeforeAll --");
        testPrinter = new TestPrinter();
        testPrinter.print("------------");
    }

    @BeforeEach
    void init() {
        testPrinter.print("-- running @BeforeEach --");
        calc = new Calc();
    }

    @Test
    public void testMultiply() {
        testPrinter.print("-- running @Test multiply --");
        testPrinter.print("calc instance: " + calc);
        int i = calc.multiply(3, 5);
        Assertions.assertEquals(15, i);
    }

    @Test
    public void testDivide() {
        testPrinter.print("-- running @Test divide --");
        testPrinter.print("calc instance: " + calc);
        int i = calc.divide(255, 5);
        Assertions.assertEquals(51, i);
    }

    @Test
    public void testAdd() {
        testPrinter.print("-- running @Test add --");
        testPrinter.print("calc instance: " + calc);
        int i = calc.add(6, 5);
        Assertions.assertEquals(11, i);

    }

    @AfterEach
    void afterEachTest(){
        testPrinter.print("-- running @AfterEach --");
        calc.dispose();
        testPrinter.print("-------------");
    }

    @AfterAll
    static void afterAll() {
        testPrinter.print("-- running @AfterAll --");
        testPrinter.dispose();
    }
}