package com.logicbig.example;

import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import java.lang.reflect.Method;

public class PerformanceInterceptor implements InvocationInterceptor {

    @Override
    public void interceptTestMethod(Invocation<Void> invocation,
                                    ReflectiveInvocationContext<Method> invocationContext,
                                    ExtensionContext extensionContext) throws Throwable {

        long startTime = System.currentTimeMillis();

        try {
            invocation.proceed();
        } finally {
            long duration = System.currentTimeMillis() - startTime;
            String testName = extensionContext.getDisplayName();

            System.out.println(String.format("Test [%s] took %d ms", testName, duration));
        }
    }
}