package com.logicbig.example;

import org.junit.jupiter.api.Test;
import static org.junit.jupiter.api.Assertions.fail;

public class ManualFailExamples {

    @Test
    void testBasicFail() {
        // Manually fail the test
        fail("This test is intentionally failing");
    }

    @Test
    void testConditionalFail() {
        int result = performCalculation();
        
        if (result < 0) {
            fail("Result should not be negative. Got: " + result);
        }
        // Test continues if result is not negative
    }
    
    private int performCalculation() {
        return -5; // Simulating a negative result
    }
}