package com.logicbig.example;

import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(DependencyInjectionExtension.class)
public class TestInstanceExtensionTest implements InjectableTest {
    
    private MockService service;
    
    @Override
    public void setService(MockService service) {
        this.service = service;
    }
    
    @Test
    void testWithInjectedService1() {
        System.out.println("Executing testWithInjectedService1");
        if (service != null) {
            service.execute("test operation 1");
            System.out.println("Service active: " + service.isActive());
        }
    }
    
    @Test
    void testWithInjectedService2() {
        System.out.println("Executing testWithInjectedService2");
        if (service != null) {
            service.execute("test operation 2");
            System.out.println("Service active: " + service.isActive());
        }
    }
}