package com.logicbig.example;

import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtendWith;

@TestInstance(TestInstance.Lifecycle.PER_CLASS)
@ExtendWith(DependencyInjectionExtension.class)
public class PerClassLifecycleTest implements InjectableTest {
    
    private MockService service;
    private int executionCount = 0;
    
    @Override
    public void setService(MockService service) {
        this.service = service;
    }
    
    @Test
    void firstTest() {
        executionCount++;
        System.out.println("Executing firstTest (Execution #" + executionCount + ")");
        if (service != null) {
            service.execute("first operation");
            System.out.println("Service ID retained: " + service.getId());
        }
    }
    
    @Test
    void secondTest() {
        executionCount++;
        System.out.println("Executing secondTest (Execution #" + executionCount + ")");
        if (service != null) {
            service.execute("second operation");
            System.out.println("Same service instance: " + service.getId());
            System.out.println("State maintained: executionCount = " + executionCount);
        }
    }
}