package com.logicbig.example;

import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(FailureAnalysisExtension.class)
public class FailureHandlingTest {
    
    @Test
    void successfulTest() {
        System.out.println("Executing successfulTest");
        // This test should pass
        int result = 2 + 2;
        System.out.println("Result: " + result);
    }
    
    @Test
    void testWithNullPointerException() {
        System.out.println("Executing testWithNullPointerException");
        String text = null;
        // This will throw NullPointerException
        System.out.println("Text length: " + text.length());
    }
    
    @Test
    void testWithIllegalArgumentException() {
        System.out.println("Executing testWithIllegalArgumentException");
        // This will throw IllegalArgumentException
        validatePositiveNumber(-5);
    }
    
    @Test
    @RetryOnException(value = {NetworkTimeoutException.class}, maxAttempts = 2)
    void testWithRetryOnNetworkTimeout() {
        System.out.println("Executing testWithRetryOnNetworkTimeout");
        
        // Simulate network operation that might timeout
        boolean networkAvailable = false; // Simulate network issue
        
        if (!networkAvailable) {
            throw new NetworkTimeoutException("Network connection timed out after 5000ms");
        }
        
        System.out.println("Network operation completed");
    }
    
    @Test
    @RetryOnException(value = {IllegalArgumentException.class}, maxAttempts = 3, delayMillis = 200)
    void testWithRetryOnIllegalArgument() {
        System.out.println("Executing testWithRetryOnIllegalArgument");
        
        // Simulate flaky validation that might fail initially
        double arg = Math.random();
        System.out.println("Random value: " + arg);
        
        if (arg < 1) {
            throw new IllegalArgumentException("Value " + arg + " is too low");
        }
        
        System.out.println("Validation passed");
    }
    
    private void validatePositiveNumber(int number) {
        if (number < 0) {
            throw new IllegalArgumentException("Number must be positive: " + number);
        }
        System.out.println("Validated positive number: " + number);
    }
}