package com.logicbig.example;

import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.*;
import java.lang.reflect.Method;

public class PolicyInvocationExtension implements InvocationInterceptor {
    
    private static final ExtensionContext.Namespace NS =
            ExtensionContext.Namespace.create(PolicyInvocationExtension.class);

    @Override
    public void interceptTestMethod(
            Invocation<Void> invocation,
            ReflectiveInvocationContext<Method> invocationContext,
            ExtensionContext context) throws Throwable {
        
        System.out.println("\n=== POLICY ENFORCEMENT ===");
        System.out.println("Test: " + context.getDisplayName());
        
        // Store custom value for ParameterResolver
        String policyId = "POLICY-" + System.currentTimeMillis();
        context.getStore(NS).put("policyId", policyId);
        System.out.println("[POLICY] Generated policy ID: " + policyId);
        
        Object instance = context.getRequiredTestInstance();
        
        // Find the policy verification method
        Method policyMethod =
                context.getRequiredTestClass()
                       .getDeclaredMethod("verifyPolicy",
                                         TestInfo.class,
                                         String.class);
        
        System.out.println("[INVOKE] Using ExecutableInvoker to call verifyPolicy");
        System.out.println("[INVOKE] Method: " + policyMethod.getName());
        
        // Correct invocation using ExecutableInvoker (no ExtensionContext argument)
        // Parameters will be resolved by registered ParameterResolvers
        context.getExecutableInvoker().invoke(policyMethod, instance);
        
        System.out.println("[POLICY] Policy verification successful");
        System.out.println("[PROCEED] Continuing with normal test execution");
        
        // Continue with normal test execution
        invocation.proceed();
    }
}