package com.logicbig.example;

import org.junit.jupiter.api.extension.*;
import java.lang.reflect.Parameter;

public class PolicyIdParameterResolver implements ParameterResolver {
    
    private static final ExtensionContext.Namespace NS =
            ExtensionContext.Namespace.create(PolicyInvocationExtension.class);

    @Override
    public boolean supportsParameter(
            ParameterContext pc,
            ExtensionContext ec) {

        return pc.isAnnotated(PolicyId.class)
                && pc.getParameter().getType() == String.class;
    }

    @Override
    public Object resolveParameter(
            ParameterContext pc,
            ExtensionContext ec) {

        return ec.getStore(NS)
                 .get("policyId", String.class);
    }
}