package com.logicbig.example;

import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import org.opentest4j.TestAbortedException;

@ExtendWith({PolicyInvocationExtension.class, PolicyIdParameterResolver.class})
public class PolicyDrivenTest2 {
    
    void verifyPolicy(TestInfo testInfo, @PolicyId String id) {
        System.out.println("[VERIFY] ExecutableInvokerTest policy verification");
        System.out.println("[VERIFY] Test: " + testInfo.getDisplayName());
        System.out.println("[VERIFY] Policy ID: " + id);
        
        // Additional validation logic
        if (testInfo.getTags().contains("skip")) {
            System.out.println("[VERIFY] Test marked for skipping");
            throw new TestAbortedException("Test should be skipped based on policy");
        }
    }
    
    @Test
    void normalTest() {
        System.out.println("[TEST] Executing normal test");
        // This test will execute normally after policy verification
    }
    
    @Test
    @Tag("skip")
    void testWithComplexLogic() {
        System.out.println("[TEST] Executing test with complex logic");
    }
}