package com.logicbig.example;

import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ExtensionContext.Namespace;
import static org.junit.jupiter.api.extension.ExtensionContext.Store;
import static org.junit.jupiter.api.extension.ExtensionContext.StoreScope;

public class SessionCounterExtension implements BeforeEachCallback {

    private static final Namespace SESSION_NAMESPACE = Namespace.create(
            SessionCounterExtension.class.getName(),
            "session-state"
    );


    @Override
    public void beforeEach(ExtensionContext context) {
        // Access LAUNCHER_SESSION scope for cross-session persistence
        Store sessionStore = context.getStore(StoreScope.LAUNCHER_SESSION, SESSION_NAMESPACE);
        Integer sessionCounter = sessionStore.get("session-counter", Integer.class);

        if (sessionCounter == null) {
            sessionCounter = 1000; // Higher starting value for session scope
            System.out.println("Initializing session counter: " + sessionCounter);
        } else {
            System.out.println("Retrieved session counter: " + sessionCounter);
        }

        // Increment session counter
        sessionCounter++;
        sessionStore.put("session-counter", sessionCounter);
        System.out.println("Updated session counter: " + sessionCounter);

        // Also demonstrate EXECUTION_REQUEST scope
        Store requestStore = context.getStore(StoreScope.EXECUTION_REQUEST, SESSION_NAMESPACE);
        Integer requestCounter = requestStore.get("request-counter", Integer.class);
        if (requestCounter == null) {
            requestCounter = 2000; // Different starting value for request scope
            System.out.println("initialized request counter: " + requestCounter);
        }else{
            System.out.println("Retrieved request counter "+requestCounter);
        }
        requestCounter++;
        requestStore.put("request-counter", requestCounter);
        System.out.println("Updated request counter: " + requestCounter);
    }
}