package com.logicbig.example;

import org.junit.jupiter.api.extension.*;
import org.junit.jupiter.api.extension.ExtensionContext.Namespace;
import org.junit.jupiter.api.extension.ExtensionContext.Store;

public class CounterExtension implements BeforeEachCallback, AfterEachCallback {
    
    private static final String COUNTER_KEY = "test-counter";
    private static final Namespace NAMESPACE = Namespace.create(
        CounterExtension.class.getName(), 
        "counter-state"
    );
    
    @Override
    public void beforeEach(ExtensionContext context) {
        // Using default EXTENSION_CONTEXT scope
        Store store = context.getStore(NAMESPACE);
        Integer counter = store.get(COUNTER_KEY, Integer.class);
        
        if (counter == null) {
            // First test in this context
            counter = 100;
            System.out.println("Initializing counter: " + counter);
        } else {
            System.out.println("Retrieved counter: " + counter);
        }
        
        // Increment and store
        counter++;
        store.put(COUNTER_KEY, counter);
        System.out.println("Stored counter: " + counter);
    }
    
    @Override
    public void afterEach(ExtensionContext context) {
        Store store = context.getStore(NAMESPACE);
        Integer counter = store.get(COUNTER_KEY, Integer.class);
        System.out.println("Test completed. Final counter: " + counter);
    }
}