package com.logicbig.example;

import org.junit.jupiter.api.extension.*;

import java.util.UUID;

public class OrderIdParameterResolver implements
        ParameterResolver {

    @Override
    public boolean supportsParameter(ParameterContext pc, ExtensionContext ec) {
        return pc.isAnnotated(OrderId.class) && pc.getParameter().getType() == String.class;
    }

    @Override
    public Object resolveParameter(ParameterContext pc, ExtensionContext ec) {
        // Generate dynamic value (UUID, timestamp, etc.)
        return "ORDER-"+UUID.randomUUID().toString();
    }
}