package com.logicbig.example;

import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(ConfigurableRetryExtension.class)
public class ConfigurationParameterTest {
    
    @Test
    void successfulTest() {
        System.out.println("[TEST] Executing successful test");
        // This test should pass
        int result = 10 + 5;
        System.out.println("[TEST] Result: " + result);
    }
    
    @Test
    void testWithTimeoutException() {
        System.out.println("[TEST] Executing test that throws TimeoutException");
        // Simulate timeout
        throw new RuntimeException("Connection timeout after 5000ms");
    }
    
    @Test
    void testWithNetworkException() {
        System.out.println("[TEST] Executing test that throws NetworkException");
        // Simulate network error
        throw new RuntimeException("Network unreachable");
    }
    
    @Test
    void testWithValidationException() {
        System.out.println("[TEST] Executing test that throws ValidationException");
        // This exception type is not in retry configuration
        throw new RuntimeException("Validation failed: invalid input");
    }
}