package com.logicbig.example;

import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfSystemProperty;
import org.junit.jupiter.api.condition.EnabledIfSystemProperty;

import static org.junit.jupiter.api.Assertions.assertTrue;

class SystemPropertyConditionExamplesTest {

    @Test
    @EnabledIfSystemProperty(named = "demo.mode", matches = "(?i)on|yes|true")
    void runs_only_when_demo_mode_is_on() {
        assertTrue(true);
    }

    @Test
    @DisabledIfSystemProperty(named = "featureX.enabled", matches = "no|false")
    void skipped_when_featureX_enabled_is_false() {
        assertTrue(true);
    }

    @Test
    void always_runs_control() {
        assertTrue(true);
    }
}