package com.logicbig.example;

import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfEnvironmentVariable;
import org.junit.jupiter.api.condition.EnabledIfEnvironmentVariable;

import static org.junit.jupiter.api.Assertions.assertTrue;

class EnvironmentVariableConditionExamplesTest {

    @Test
    @EnabledIfEnvironmentVariable(named = "APP_ENV", matches = "dev|test")
    void runs_only_in_dev_or_test_env() {
        assertTrue(true);
    }

    @Test
    @DisabledIfEnvironmentVariable(named = "CI", matches = "true")
    void skipped_on_ci_servers() {
        assertTrue(true);
    }

    @Test
    void always_runs_control() {
        assertTrue(true);
    }
}