package com.logicbig.example;

import org.junit.jupiter.api.MethodDescriptor;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.MethodOrdererContext;
import java.util.Comparator;

public class ReverseNameMethodOrderer implements MethodOrderer {

    @Override
    public void orderMethods(MethodOrdererContext context) {
        Comparator<MethodDescriptor> comparator = Comparator.comparing(
                (MethodDescriptor o) -> o.getMethod()
                                         .getName());
        context.getMethodDescriptors()
               .sort(comparator.reversed());
    }
}