package com.logicbig.example;

import org.junit.jupiter.api.ClassDescriptor;
import org.junit.jupiter.api.ClassOrderer;
import org.junit.jupiter.api.ClassOrdererContext;
import java.util.Comparator;

public class OrderAnnotationClassOrderer implements ClassOrderer {

    @Override
    public void orderClasses(ClassOrdererContext context) {
        context.getClassDescriptors().sort(
                Comparator.comparingInt(
                        (ClassDescriptor o) ->
                                getSimpleClassLength(o))
        );
    }

    private static int getSimpleClassLength(ClassDescriptor o) {
        return o.getTestClass()
                .getSimpleName().length();
    }
}