package com.logicbig.example;

import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertTrue;
import static org.junit.jupiter.api.Assumptions.assumeFalse;
import static org.junit.jupiter.api.Assumptions.assumeTrue;

public class AssumeTrueFalseExamples {

    @Test
    void assumeTruePassTest() {
        assumeTrue(5 > 2, "Expected 5 > 2");
        // If we get here, the assumption passed
        assertTrue(true);
    }

    @Test
    void assumeTrueFailTest() {
        // This assumption is intentionally false; the test will be aborted (skipped)
        assumeTrue(() -> 2 > 3, () -> "Assumption failed: 2 is not greater than 3");
        // The following line won't execute if the assumption fails
        assertTrue(false, "Should not reach here when assumption fails");
    }

    @Test
    void assumeFalsePassTest() {
        assumeFalse("abc".isEmpty(), "String should not be empty");
        assertTrue(true);
    }

    @Test
    void assumeFalseFailTest() {
        // Intentionally making assumption fail; test will be skipped
        assumeFalse(() -> 10 < 20, () -> "Assumption failed: 10 < 20 is true");
        assertTrue(false, "Should not reach here when assumption fails");
    }

    @Test
    void assumeOnEnvironmentExampleTest() {
        String os = System.getProperty("os.name", "").toLowerCase();
        assumeTrue(os.contains("win"), () -> "Test only relevant on Windows. Current OS: " + os);
        assertTrue(os.contains("win"));
    }
}