package com.logicbig.example;

import org.junit.jupiter.api.Test;

import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;

import static org.junit.jupiter.api.Assertions.assertFalse;
import static org.junit.jupiter.api.Assertions.assertTrue;
import static org.junit.jupiter.api.Assumptions.assumingThat;


public class AssumeThatExamples {

    @Test
    void assumingThatPassTest() {
        AtomicBoolean ran = new AtomicBoolean(false);

        assumingThat(5 > 2, () -> ran.set(true));

        assertTrue(ran.get(), "executable should run when condition is true");
    }

    @Test
    void assumingThatFailTest() {
        AtomicBoolean ran = new AtomicBoolean(false);

        // condition is false, executable should not run, but the test must proceed
        assumingThat(2 > 3, () -> ran.set(true));

        assertFalse(ran.get(), "executable should not run when condition is false");
        // the test still continues and can make further assertions
        assertTrue(true);
    }

    @Test
    void assumingThatWithBooleanSupplier() {
        AtomicBoolean ran = new AtomicBoolean(false);

        assumingThat(() -> "junit".startsWith("ju"), () -> ran.set(true));

        assertTrue(ran.get());
    }

    @Test
    void assumingThatWithEnvironmentSpecificCheck() {
        String os = System.getProperty("os.name", "").toLowerCase(Locale.ROOT);
        AtomicBoolean executed = new AtomicBoolean(false);

        // Only execute the block when running on Windows
        assumingThat(os.contains("win"), () -> executed.set(true));

        if (os.contains("win")) {
            assertTrue(executed.get(), "block should execute on Windows");
        } else {
            assertFalse(executed.get(), "block should not execute on non-Windows");
        }
    }

    @Test
    void assumingThatNotAbortTestOnFalse() {
        // Demonstrate that assumingThat does not abort; it only skips the block
        AtomicBoolean sideEffect = new AtomicBoolean(false);
        assumingThat(false, () -> sideEffect.set(true));
        // still reaches here
        assertFalse(sideEffect.get());
    }
}