package com.logicbig.example;

import org.junit.jupiter.api.Test;
import static org.junit.jupiter.api.Assertions.assertNotSame;
import static org.junit.jupiter.api.Assertions.assertSame;

class ReferenceEqualityExamples {

    @Test
    void testSameObjectReference() {
        String str1 = "hello";
        String str2 = str1; // Same reference

        assertSame(str1, str2);
    }

    @Test
    void testNotSameObjectReference() {
        String str1 = new String("hello");
        String str2 = new String("hello"); // Different objects

        assertNotSame(str1, str2);
    }
}