package com.logicbig.example;

import org.junit.jupiter.api.Test;
import static org.junit.jupiter.api.Assertions.assertNull;
import static org.junit.jupiter.api.Assertions.assertNotNull;

class NullAssertionsTest {

    @Test
    void testAssertNull() {
        String nullValue = null;
        Integer nullNumber = null;
        
        assertNull(nullValue); 
        assertNull(nullNumber);
    }

    @Test
    void testAssertNotNull() {
        String name = "John";
        Integer age = 25;
        Object obj = new Object();
        
        assertNotNull(name);
        assertNotNull(age);
        assertNotNull(obj);
    }

    @Test
    void testArrayAndCollections() {
        String[] emptyArray = new String[0];
        String[] nullArray = null;
        
        assertNotNull(emptyArray);
        assertNull(nullArray);   
    }

    @Test
    void testWithCustomMessages() {
        String nullString = null;
        String actualString = "Hello";
        
        assertNull(nullString, "This string should be null");
        assertNotNull(actualString, "This string should not be null");
    }
}