package com.logicbig.example;

import org.junit.jupiter.api.Test;

import java.util.Arrays;
import java.util.List;

import static org.junit.jupiter.api.Assertions.assertLinesMatch;

class AssertLinesMatchExampleTest {

    @Test
    void exactMatch() {
        List<String> expected = Arrays.asList(
                "Hello",
                "World"
        );

        List<String> actual = Arrays.asList(
                "Hello",
                "World"
        );

        assertLinesMatch(expected, actual);
    }

    @Test
    void regexMatch() {
        List<String> expected = Arrays.asList(
                "User: .*",     // regex match for whole line
                "Age: \\d+"     // regex for digits
        );

        List<String> actual = Arrays.asList(
            "User: Alice",
            "Age: 30"
        );

        assertLinesMatch(expected, actual);
    }

    @Test
    void mixedLiteralAndRegex() {
        List<String> expected = Arrays.asList(
                "START",
                "Value: \\d+",
                "END"
        );

        List<String> actual = Arrays.asList(
                "START",
                "Value: 42",
                "END"
        );

        assertLinesMatch(expected, actual);
    }

    @Test
    void testAssertLinesMatchWithFastForward() {
        List<String> expected = Arrays.asList(
                "Start of log",
                ">>>>", // Fast-forward marker to skip a single line
                "Important value: \\d+", // Regex to match the next line
                ">> stacktrace >>", // Fast-forward marker to skip multiple lines
                "End of log"
        );

        List<String> actual = Arrays.asList(
                "Start of log",
                "This line is skipped by the first marker",
                "Important value: 42", // Matches the regex in expected
                "Here is the first line of the stacktrace...",
                "And the second line...",
                "And the third...",
                "End of log" // Matches the final expected line
        );

        // The assertion passes because the markers handle the mismatches
        assertLinesMatch(expected, actual);
    }
}