package com.logicbig.example;

import org.junit.jupiter.api.Test;
import static org.junit.jupiter.api.Assertions.*;

class ExceptionHandlingTest {

    @Test
    void testExceptionIsThrown() {
        // >> Verifying that an exception is thrown
        assertThrows(IllegalArgumentException.class, () -> {
            throw new IllegalArgumentException("Invalid argument");
        });
    }

    @Test
    void testExceptionWithMessage() {
        // >> Verifying exception with a specific message
        IllegalArgumentException exception = assertThrows(IllegalArgumentException.class, () -> {
            throw new IllegalArgumentException("Invalid argument");
        });

        // >> Checking the exception message
        assert(exception.getMessage()).equals("Invalid argument");
    }

    @Test
    void testNoExceptionIsThrown() {
        // >> Verifying no exception is thrown during code execution
        assertDoesNotThrow(() -> {
            String str = "Hello, World!";
            // No exception here
        });
    }

    @Test
    void testExactExceptionIsThrown() {
        // >> Verifying that exactly the specified exception (IllegalArgumentException) is thrown
        assertThrowsExactly(IllegalArgumentException.class, () -> {
            throw new IllegalArgumentException("Exact exception");
        });
    }

    @Test
    void testNoExceptionWithMethodCall() {
        // >> Verifying no exception is thrown during method execution
        assertDoesNotThrow(() -> {
            myMethod();
        });
    }

    // A simple method that doesn't throw an exception
    void myMethod() {
        System.out.println("Method executed successfully");
    }
}