package com.logicbig.example;

import org.junit.jupiter.api.Test;
import static org.junit.jupiter.api.Assertions.assertTrue;
import static org.junit.jupiter.api.Assertions.assertFalse;

public class TrueFalseExamples {
    
    @Test
    void testBasicConditions() {
        int number = 10;
        
        assertTrue(number > 5);
        assertTrue(number == 10);
        assertFalse(number < 5);
        assertFalse(number == 15);
    }
    
    @Test
    void testStringOperations() {
        String name = "John Doe";
        
        assertTrue(name.startsWith("John"));
        assertTrue(name.contains("Doe"));
        assertFalse(name.isEmpty());
        assertFalse(name.endsWith("Smith"));
    }
    
    @Test
    void testListOperations() {
        java.util.List<String> fruits = new java.util.ArrayList<>();
        fruits.add("apple");
        fruits.add("banana");
        
        assertTrue(fruits.contains("apple"));
        assertTrue(fruits.size() == 2);
        assertFalse(fruits.contains("orange"));
        assertFalse(fruits.isEmpty());
    }
}