package com.logicbig.example;

import org.junit.jupiter.api.Test;

import static org.assertj.core.api.Assertions.*;

public class RecursiveComparisonExample {

    static class Address {
        String city;
        String zip;

        Address(String city,
                String zip) {
            this.city = city;
            this.zip = zip;
        }
    }

    static class Customer {
        int id;
        String name;
        Address address;

        Customer(int id,
                 String name,
                 Address address) {
            this.id = id;
            this.name = name;
            this.address = address;
        }
    }

    @Test
    void myTest() {
        Customer actual = new Customer(1,
                                       "Alice",
                                       new Address("London", "SW1A"));
        Customer expected = new Customer(99,
                                         "Alice",
                                         new Address("London", "SW1A"));

        // ignore id (differs), compare everything else deeply
        assertThat(actual).usingRecursiveComparison()
                          .ignoringFields("id")
                          .isEqualTo(expected);
        System.out.println("Recursive comparison with ignored field passed");

        // full comparison - same id
        Customer same = new Customer(1, "Alice", new Address("London", "SW1A"));
        assertThat(actual).usingRecursiveComparison().isEqualTo(same);
        System.out.println("Full recursive comparison passed");
    }
}