package com.logicbig.example;

import org.junit.jupiter.api.Test;

import java.util.Optional;
import static org.assertj.core.api.Assertions.*;

public class OptionalAssertionsExample {

    @Test
    void myTest() {
        Optional<String> present = Optional.of("hello");
        Optional<String> empty = Optional.empty();

        // presence
        assertThat(present).isPresent();
        assertThat(empty).isEmpty();
        System.out.println("Presence checks passed");

        // exact value
        assertThat(present).hasValue("hello");
        System.out.println("hasValue passed");

        // contains (alias for hasValue)
        assertThat(present).contains("hello");
        System.out.println("contains passed");

        // custom condition on the wrapped value
        assertThat(present).hasValueSatisfying(s -> {
            assertThat(s).startsWith("he").hasSize(5);
        });
        System.out.println("hasValueSatisfying passed");
    }
}