package com.logicbig.example;

import org.junit.jupiter.api.Test;

import java.math.BigDecimal;
import static org.assertj.core.api.Assertions.*;

public class NumberAssertionsExample {

    @Test
    void myTest() {
        // integer range checks
        assertThat(42).isGreaterThan(10)
                      .isLessThanOrEqualTo(42)
                      .isBetween(1, 100);
        System.out.println("Integer range passed");

        // sign checks
        assertThat(-5).isNegative();
        assertThat(0).isZero();
        assertThat(7).isPositive();
        System.out.println("Sign checks passed");

        // floating point with offset
        assertThat(3.14159).isCloseTo(3.14, within(0.01));
        System.out.println("Double closeTo passed");

        // BigDecimal
        assertThat(new BigDecimal("9.99")).isGreaterThan(new BigDecimal("5.00"))
                                          .isLessThan(new BigDecimal("10.00"));
        System.out.println("BigDecimal checks passed");
    }
}