package com.logicbig.example;

import org.junit.jupiter.api.Test;

import java.util.Map;
import static org.assertj.core.api.Assertions.*;

public class MapAssertionsExample {

    @Test
    void myTest() {
        Map<String, Integer> scores = Map.of("Alice",
                                             95,
                                             "Bob",
                                             80,
                                             "Charlie",
                                             70);

        // key checks
        assertThat(scores).containsKey("Alice")
                          .doesNotContainKey("Dave");
        System.out.println("Key checks passed");

        // value checks
        assertThat(scores).containsValue(95)
                          .doesNotContainValue(100);
        System.out.println("Value checks passed");

        // exact entry
        assertThat(scores).containsEntry("Bob", 80);
        System.out.println("Entry check passed");

        // using entry() helper
        assertThat(scores).contains(entry("Alice", 95), entry("Charlie", 70));
        System.out.println("entry() helper check passed");

        // size
        assertThat(scores).hasSize(3);
        System.out.println("Size check passed");
    }
}