package com.logicbig.example;

import org.junit.jupiter.api.Test;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import static org.assertj.core.api.Assertions.*;

public class FilePathAssertionsExample {

    @Test
    void myTest() throws IOException {
        // create a temp file with content
        Path tempFile = Files.createTempFile("assertj-test-", ".txt");
        Files.writeString(tempFile, "hello assertj");

        File file = tempFile.toFile();

        // file existence and type
        assertThat(file).exists().isFile().isReadable();
        System.out.println("Existence/type checks passed");

        // file content
        assertThat(file).hasContent("hello assertj");
        System.out.println("Content check passed");

        // NIO Path
        assertThat(tempFile).exists().isReadable();
        System.out.println("Path assertion passed");

        // directory check
        File dir = tempFile.getParent().toFile();
        assertThat(dir).isDirectory();
        System.out.println("Directory check passed");

        // cleanup
        Files.deleteIfExists(tempFile);
    }
}