package com.logicbig.example;

import org.junit.jupiter.api.Test;

import java.util.List;
import static org.assertj.core.api.Assertions.*;

public class ExtractingFilteringExample {

    static class Person {
        String name;
        int age;

        Person(String name,
               int age) {
            this.name = name;
            this.age = age;
        }

        public String getName() {return name;}

        public int getAge() {return age;}
    }

    @Test
    void myTest() {
        List<Person> people = List.of(
                new Person("Alice", 30),
                new Person("Bob", 25),
                new Person("Charlie", 30)
        );

        // extracting a single property
        assertThat(people).extracting(Person::getName)
                          .contains("Alice", "Bob", "Charlie");
        System.out.println("Name extraction passed");

        // extracting multiple fields as tuples
        assertThat(people).extracting("name", "age")
                          .contains(tuple("Alice", 30), tuple("Bob", 25));
        System.out.println("Tuple extraction passed");

        // filter then extract
        assertThat(people).filteredOn(p -> p.age == 30)
                          .extracting(Person::getName)
                          .containsOnly("Alice", "Charlie");
        System.out.println("FilteredOn + extracting passed");
    }
}