package com.logicbig.example;

import org.junit.jupiter.api.Test;

import static org.assertj.core.api.Assertions.*;

public class CorrectUsageExample {

    @Test
    void myTest() {
        String actual = "hello";
        String expected = "hello";

        // CORRECT: assertThat(actual) then assertion method
        assertThat(actual).isEqualTo(expected);
        System.out.println("Correct equality check passed");

        // CORRECT: as() before assertion
        assertThat(actual).as("string value check").isEqualTo(expected);
        System.out.println("Correct as() usage passed");

        // CORRECT: withFailMessage before assertion
        assertThat(42).withFailMessage("should be 42").isEqualTo(42);
        System.out.println("Correct withFailMessage passed");

        // CORRECT: usingComparator before assertion
        assertThat(actual).usingComparator(String.CASE_INSENSITIVE_ORDER)
                          .isEqualTo("HELLO");
        System.out.println("Correct comparator usage passed");
    }
}