package com.logicbig.example;

import org.junit.jupiter.api.Test;

import java.util.List;
import java.util.Set;
import static org.assertj.core.api.Assertions.*;

public class CollectionAssertionsExample {

    @Test
    void myTest() {
        List<String> fruits = List.of("apple", "banana", "cherry");

        // size and presence
        assertThat(fruits).hasSize(3)
                          .contains("banana")
                          .doesNotContain("mango");
        System.out.println("Size and presence passed");

        // exact order
        assertThat(fruits).containsExactly("apple", "banana", "cherry");
        System.out.println("Exact order check passed");

        // containsOnly: any order, no extras
        assertThat(fruits).containsOnly("cherry", "apple", "banana");
        System.out.println("containsOnly passed");

        // Set: no duplicates
        Set<Integer> nums = Set.of(1, 2, 3);
        assertThat(nums).isNotEmpty()
                        .hasSize(3);
        System.out.println("Set assertion passed");
    }
}