package com.logicbig.example;

import org.junit.jupiter.api.Test;
import static org.assertj.core.api.Assertions.assertThat;

public class AssertionDescriptionExample {

    record User(String name,
                int age) {}

    @Test
    void myTest() {
        User alice = new User("Alice", 30);

        // describe before the assertion
        assertThat(alice.name()).as("check user name").isEqualTo("Alice");
        System.out.println("Named assertion passed");

        // format string in description
        assertThat(alice.age()).as("check %s's age", alice.name())
                               .isGreaterThan(18);
        System.out.println("Formatted description passed");

        // multiple assertions with individual descriptions
        assertThat(alice.name()).as("name not blank").isNotBlank();
        assertThat(alice.age()).as("valid age range").isBetween(0, 120);
        System.out.println("All described assertions passed");
    }
}